//******************************************************************************
// PLC: MAIN (& COMPILER)                       Copyright 1999 Adept Software **
//                                                                            **
// PLC is recursive, large programs may require a large stack size            **
//******************************************************************************

#ifndef PLC_MAIN_H
#define PLC_MAIN_H

#include "Adept.H"

//******************************************************************************
//******************************************************************************
// INTERFACE

#define PLC_PARM_MAX			20

//**************************************
// COMMON - chars / strings used to identify code elements common to most languages,

#define PLC_COMMON_STRMAX		80
struct PLC_COMMON
{
	// single char
	char	*ParmSeparator,
			*ParmOpen,*ParmClose,
			*ExprOpen,*ExprClose,
			*StringOpen,*StringClose;
	// char list
	char	*Whitespace,*EndLine,
			*StatementTerminator,*DeclarationTerminator,
			*Number,*DataTypeStart,
			*Symbol,*SymbolStart;
	// string
	char	*CommentLine,
			*CommentStart,*CommentEnd,
			*CompoundOpen,*CompoundClose,
			*LabelOpen,*LabelClose,
			*KeyOpen,*KeyClose,
			*KeyDivider;
};

//**************************************
// KEYWORD

#define PLC_KEYWORD_NAMEMAX		12
#define PLC_KEYWORD_FORMATMAX	15
struct PLC_KEYWORD
{
	char	Name[PLC_KEYWORD_NAMEMAX+1],
			String1[PLC_KEYWORD_NAMEMAX+1],String2[PLC_KEYWORD_NAMEMAX+1];
	byte	Format[PLC_KEYWORD_FORMATMAX];
};
	enum
	{
		PLC_KEY_DONE,
		PLC_KEY_STRING1,PLC_KEY_STRING2,
		PLC_KEY_OPEN,PLC_KEY_CLOSE,PLC_KEY_DIVIDER,
		PLC_KEY_STATEMENT,
		PLC_KEY_EXPRESSION,
		PLC_KEY_SYMBOL,
		PLC_KEY_DATATYPE,
	};

//**************************************
// OPERATOR

#define PLC_OPERATOR_NAMEMAX		12
struct PLC_OPERATOR
{
	char	Name[PLC_OPERATOR_NAMEMAX+1];
	byte	Precedence;
	bool	Reverse;
	byte	Type;
};
	enum
	{
		PLC_OP_PREV,PLC_OP_NEXT,
		PLC_OP_PREVIFNONEXT,PLC_OP_NEXTIFNOPREV,	// operator used only if there is nothing on one side
		PLC_OP_BOTH,
	};

//******************************************************************************
// TOKEN

struct PLC_TOKEN
{
	LNK_LINK	Link;
	byte		Type,SubType;
	word		LineNum;
	byte		Extra[sizeof(LNK_LINK)];
		#define PLC_TOK_Anchor(Token)	((LNK_LINK*)(Token)->Extra)
		#define PLC_TOK_Pointer(Token)	(_voidptr((Token)->Extra[0]))
};
	// TYPES
	enum
	{
		PLC_TT_NONE=0,
		// STATEMENT ELEMENTS
		PLC_TT_COMPOUND,
		PLC_TT_EXPRESSION,
		PLC_TT_KEYWORD,
		PLC_TT_LABEL,

		// EXPRESSION ELEMENTS
		PLC_TT_OPERATOR,
		PLC_TT_DATATYPE,
		PLC_TT_VARIABLE,
		PLC_TT_ROUTINE,
		PLC_TT_SYMBOL,
		PLC_TT_PARMLIST,
	};
	// SUBTYPES
	enum
	{
		// variables
		PLC_TT_NORMAL=0,
		PLC_TT_NEW,
	};

#define PLC_TOKENNEXT(Token)		((PLC_TOKEN*)LNK_Next(Token))
#define PLC_TOKENPREV(Token)		((PLC_TOKEN*)LNK_Prev(Token))

//**************************************
// DATATYPE

struct PLC_DATATYPE
{
	LNK_LINK	Link;
	byte		Type;
	struct	PLC_SYMBOL	*Symbol;		// useful for non-standard variable types
	byte		Data[max(sizeof(float) , 2*sizeof(void*))];
};
	enum
	{
		PLC_DT_NONE,
	};

//**************************************
// VARIABLE

struct PLC_SYMBOL;
struct PLC_VARIABLE
{
	LNK_LINK		Link;
	PLC_SYMBOL		*Symbol;
	PLC_DATATYPE	DataType;
};

//**************************************
// ROUTINE

struct PLC_ROUTINE
{
	LNK_LINK	Link;
	PLC_SYMBOL	*Symbol;
	struct	PLC_ENVIR	*Envir;
	PLC_SYMBOL	*ParmNames[PLC_PARM_MAX];
	sdword		ParmTotal;
	void		(*Command)(PLC_DATATYPE *Parms,sdword ParmTotal);
};

//**************************************
// SYMBOL

#define PLC_SYMBOL_NAMEMAX		32
struct PLC_SYMBOL
{
	LNK_LINK	Link;
	char		Name[PLC_SYMBOL_NAMEMAX+1];
	struct	PLC_TOKEN	*LabelTarget;
};

//**************************************
// ENVIRONMENT (controls scope)

struct PLC_ENVIR
{
	LNK_LINK		Link;
	PLC_ENVIR		*Parent;
	LNK_LINK		List_Envirs , List_Tokens , List_DataTypes,
					List_Variables , List_Routines , List_Symbols;
};

//******************************************************************************
//******************************************************************************
// GLOBAL VARIABLES

#undef GLOBAL
#ifdef PLC_MAIN_C
	#define GLOBAL
#else
	#define GLOBAL	extern
#endif

GLOBAL	PLC_ENVIR		PLC_EnvirGlobal,*PLC_Envir;
GLOBAL	char			*PLC_SourceBuf;
GLOBAL	sdword			PLC_SourceLine;
GLOBAL	byte			PLC_KeywordMax,PLC_OperatorMax;
GLOBAL	PLC_COMMON		PLC_Common;
GLOBAL	PLC_KEYWORD		*PLC_Keywords;
GLOBAL	PLC_OPERATOR	*PLC_Operators;
GLOBAL	void			(*PLC_Preprocess)(void);

//******************************************************************************
//******************************************************************************
// GLOBAL ROUTINES

void	PLC_Startup				(void);
void	PLC_Shutdown			(void);

void	PLC_Compile				(char *SourceBuf);
void	PLC_CompileStatements	(char *RoutineName,char *SourceBuf);

void	PLC_AddCommand			(char *Name,void (*Command)(PLC_DATATYPE *Parms,sdword ParmTotal));

// DATATYPES

extern	void	PLC_DT_Tokenize		(LNK_LINK *Anchor);

extern	void	PLC_DT_Init			(PLC_DATATYPE *DataType,byte Type);
extern	void	PLC_DT_Destroy		(PLC_DATATYPE *DataType);
extern	void	PLC_DT_Assign		(PLC_DATATYPE *Dest,PLC_DATATYPE *Source);
extern	sbyte	PLC_DT_Compare		(PLC_DATATYPE *Value1,PLC_DATATYPE *Value2);

//******************************************************************************
//******************************************************************************
#endif
