//******************************************************************************
// PLC: EXECUTOR                                Copyright 1999 Adept Software **
//******************************************************************************

#ifndef PLC_EXEC_H
#define PLC_EXEC_H

#include "Adept.H"
#include "PLC_Main.H"

//******************************************************************************
//******************************************************************************
// INTERFACE

enum
{
	PLC_FLOW_NORMAL,
	PLC_FLOW_CONTINUE,PLC_FLOW_BREAK,
	PLC_FLOW_RETURN,
	PLC_FLOW_GOTO,
};

//******************************************************************************
//******************************************************************************
// GLOBAL VARIABLES

#undef GLOBAL
#ifdef PLC_EXEC_C
	#define GLOBAL
#else
	#define GLOBAL	extern
#endif

GLOBAL	PLC_DATATYPE	PLC_Result;
GLOBAL	byte			PLC_FlowStatus;
GLOBAL	PLC_TOKEN		*PLC_GotoToken;

GLOBAL	void	(*PLC_ExecKeyword)(PLC_TOKEN *,bool *);
GLOBAL	void	(*PLC_ApplyOperator)(sdword,PLC_DATATYPE *,PLC_DATATYPE *);

//******************************************************************************
//******************************************************************************
// GLOBAL ROUTINES

void	PLC_Execute				(char *RoutineName,LNK_LINK *ParmList);
void	PLC_Evaluate			(char *SourceBuf);

void	PLC_ExecExpression		(LNK_LINK *TokenList);
void	PLC_ExecStatement		(PLC_TOKEN *Token,bool *IfResultPtr);
void	PLC_ExecCompound		(PLC_TOKEN *Token);

//******************************************************************************
//******************************************************************************
#endif
