//******************************************************************************
// PLC LANGUAGE MODULE: C                       Copyright 1998 Adept Software **
//******************************************************************************
// GOTO DOES NOT WORK BECAUSE PLC IS RECURSIVE
// you could goto a previous nest level, you would have to manually back out
// of each statement block, then execute the goto

#define	PLC_C_C
#include "PLC_C.H"
#include "PLC_DT.H"
#include "PLC_Exec.H"
#include "PLC_Tool.H"

//**************************************
// INTERFACE

// TOKEN SUBTYPES
// operator type constants and keyword type constants
enum
{
	// OPERATORS
	TT_OPR_NEGATE=0,TT_OPR_COMPLEMENT,TT_OPR_UNARY_PLUS,TT_OPR_UNARY_MINUS,
		TT_OPR_INCREMENT_PRE,TT_OPR_DECREMENT_PRE,TT_OPR_INCREMENT_POST,TT_OPR_DECREMENT_POST,
	TT_OPR_MULTIPLY,TT_OPR_DIVIDE,TT_OPR_MODULUS,
	TT_OPR_ADD,TT_OPR_SUBTRACT,
	TT_OPR_SHL,TT_OPR_SHR,
	TT_OPR_LESS,TT_OPR_LESS_EQUAL,TT_OPR_GREATER,TT_OPR_GREATER_EQUAL,
	TT_OPR_EQUAL,TT_OPR_NOT_EQUAL,
	TT_OPR_AND,
	TT_OPR_XOR,
	TT_OPR_OR,
	TT_OPR_LOGICAL_AND,
	TT_OPR_LOGICAL_OR,
	TT_OPR_CONDITIONAL_Q,TT_OPR_CONDITIONAL_C,
	TT_OPR_ASSIGN,TT_OPR_ASSIGN_MULT,TT_OPR_ASSIGN_DIV,TT_OPR_ASSIGN_MOD,TT_OPR_ASSIGN_ADD,TT_OPR_ASSIGN_SUB,
		TT_OPR_ASSIGN_AND,TT_OPR_ASSIGN_XOR,TT_OPR_ASSIGN_OR,TT_OPR_ASSIGN_SHL,TT_OPR_ASSIGN_SHR,
	TT_OPR_COMMA,
	// KEYWORDS
	TT_KEY_IF=0,TT_KEY_ELSE,
	TT_KEY_DO,TT_KEY_WHILE,
	TT_KEY_FOR,
	TT_KEY_SWITCH,TT_KEY_CASE,TT_KEY_DEFAULT,
	TT_KEY_BREAK,TT_KEY_CONTINUE,
	TT_KEY_RETURN,
//	TT_KEY_GOTO,
};

//**************************************
// LOCAL VARIABLES

// COMMON STRINGS (COMPILATION)
// chars / strings used to identify code elements common to most languages,
// including comment begin & end, characters allowed in symbol names, statement terminators, etc
PLC_COMMON	Common=
{
	// single char
	",",
	"(",")",
	"(",")",
	"\"","\"",
	// char list
	" \t\n", "\r",
	";", ";",
	"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ",
	"0123456789\".",
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_@$",
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_",
	// string
	"//",
	"/*","*/",
	"{","}",
	"",":",
	"(",")",
	";",
};

// KEYWORDS (COMPILATION)
// keywords (in order of subtype), and keyword format
PLC_KEYWORD	KeywordList[]=
{
	{	"IF","","",
		PLC_KEY_OPEN,PLC_KEY_EXPRESSION,PLC_KEY_CLOSE,
		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{	"ELSE","","",
		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{   "DO","WHILE","",
		PLC_KEY_STATEMENT,
		PLC_KEY_STRING1,
		PLC_KEY_OPEN,PLC_KEY_EXPRESSION,PLC_KEY_CLOSE,
		PLC_KEY_DONE,
	},
	{	"WHILE","","",
		PLC_KEY_OPEN,PLC_KEY_EXPRESSION,PLC_KEY_CLOSE,
		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{	"FOR","","",
		PLC_KEY_OPEN,PLC_KEY_EXPRESSION,PLC_KEY_DIVIDER,
		PLC_KEY_EXPRESSION,PLC_KEY_DIVIDER,
		PLC_KEY_EXPRESSION,PLC_KEY_CLOSE,
		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{	"SWITCH","","",
		PLC_KEY_OPEN,PLC_KEY_EXPRESSION,PLC_KEY_CLOSE,
		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{	"CASE",":","",
		PLC_KEY_DATATYPE,PLC_KEY_STRING1,
//		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{	"DEFAULT",":","",
		PLC_KEY_STRING1,
//		PLC_KEY_STATEMENT,
		PLC_KEY_DONE,
	},
	{	"BREAK","","",
		PLC_KEY_DONE,
	},
	{	"CONTINUE","","",
		PLC_KEY_DONE,
	},
	{	"RETURN","","",
		PLC_KEY_EXPRESSION,
		PLC_KEY_DONE,
	},
/*	{	"GOTO","","",
		PLC_KEY_SYMBOL,
		PLC_KEY_DONE,
	},
*/
};

// OPERATORS (COMPILATION)
// operator string, precedence, left to right or reversed, and which
// expressions (left or right of operator) are affected
PLC_OPERATOR	OperatorList[]=
{
	{"!",	0,	TRUE,	PLC_OP_NEXT,},
	{"~",	0,	TRUE,	PLC_OP_NEXT,},
	{"+",	0,	TRUE,	PLC_OP_NEXTIFNOPREV,},
	{"-",	0,	TRUE,	PLC_OP_NEXTIFNOPREV,},
	{"++",	0,	TRUE,	PLC_OP_NEXTIFNOPREV,},
	{"--",	0,	TRUE,	PLC_OP_NEXTIFNOPREV,},
	{"++",	0,	TRUE,	PLC_OP_PREV,},
	{"--",	0,	TRUE,	PLC_OP_PREV,},
	{"*",	1,	FALSE,	PLC_OP_BOTH,},
	{"/",	1,	FALSE,	PLC_OP_BOTH,},
	{"%",	1,	FALSE,	PLC_OP_BOTH,},
	{"+",	2,	FALSE,	PLC_OP_BOTH,},
	{"-",	2,	FALSE,	PLC_OP_BOTH,},
	{"<<",	3,	FALSE,	PLC_OP_BOTH,},
	{">>",	3,	FALSE,	PLC_OP_BOTH,},
	{"<",	4,	FALSE,	PLC_OP_BOTH,},
	{"<=",	4,	FALSE,	PLC_OP_BOTH,},
	{">",	4,	FALSE,	PLC_OP_BOTH,},
	{">=",	4,	FALSE,	PLC_OP_BOTH,},
	{"==",	5,	FALSE,	PLC_OP_BOTH,},
	{"!=",	5,	FALSE,	PLC_OP_BOTH,},
	{"&",	6,	FALSE,	PLC_OP_BOTH,},
	{"^",	7,	FALSE,	PLC_OP_BOTH,},
	{"|",	8,	FALSE,	PLC_OP_BOTH,},
	{"&&",	9,	FALSE,	PLC_OP_BOTH,},
	{"||",	10,	FALSE,	PLC_OP_BOTH,},
	{"?",	11,	TRUE,	PLC_OP_PREV,},
	{":",	11,	TRUE,	PLC_OP_BOTH,},
	{"=",	12,	TRUE,	PLC_OP_BOTH,},
	{"*=",	12,	TRUE,	PLC_OP_BOTH,},
	{"/=",	12,	TRUE,	PLC_OP_BOTH,},
	{"%=",	12,	TRUE,	PLC_OP_BOTH,},
	{"+=",	12,	TRUE,	PLC_OP_BOTH,},
	{"-=",	12,	TRUE,	PLC_OP_BOTH,},
	{"&=",	12,	TRUE,	PLC_OP_BOTH,},
	{"^=",	12,	TRUE,	PLC_OP_BOTH,},
	{"|=",	12,	TRUE,	PLC_OP_BOTH,},
	{"<<=",	12,	TRUE,	PLC_OP_BOTH,},
	{">>=",	12,	TRUE,	PLC_OP_BOTH,},
	{",",	13,	FALSE,	PLC_OP_BOTH,},
};

//******************************************************************************
//******************************************************************************
// LOCAL ROUTINES

// execute a keyword statement
void	ExecKeyword	(PLC_TOKEN *Token,bool *IfResultPtr)
{
	PLC_TOKEN		*Statement,*Expression1,*Expression2,*Expression3;

	switch(Token->SubType)
	{
	// IF
	case TT_KEY_IF:
		Expression1=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		Statement=PLC_TOKENNEXT(&Expression1->Link);
		PLC_ExecExpression(PLC_TOK_Anchor(Expression1));
		*IfResultPtr=PLC_DT_GetBool(&PLC_Result);
		if(*IfResultPtr) PLC_ExecStatement(PLC_TOKENNEXT(&Expression1->Link),NULL);
		break;

	// ELSE
	case TT_KEY_ELSE:
		Statement=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		if(!*IfResultPtr) PLC_ExecStatement(Statement,NULL);
		break;

	// DO .. WHILE
	case TT_KEY_DO:
		Statement=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		Expression1=PLC_TOKENNEXT(&Statement->Link);
		do
		{
			PLC_ExecStatement(Statement,NULL);
			if(PLC_FlowStatus==PLC_FLOW_BREAK) {PLC_FlowStatus=PLC_FLOW_NORMAL; break;}
			else if(PLC_FlowStatus==PLC_FLOW_RETURN || PLC_FlowStatus==PLC_FLOW_GOTO) break;
			else if(PLC_FlowStatus==PLC_FLOW_CONTINUE) PLC_FlowStatus=PLC_FLOW_NORMAL;
			PLC_ExecExpression(PLC_TOK_Anchor(Expression1));
		}while(( *IfResultPtr=PLC_DT_GetBool(&PLC_Result) ) != 0);
		break;

	// WHILE
	case TT_KEY_WHILE:
		Expression1=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		Statement=PLC_TOKENNEXT(&Expression1->Link);
		while(1)
		{
			PLC_ExecExpression(PLC_TOK_Anchor(Expression1));
			if(! (*IfResultPtr=PLC_DT_GetBool(&PLC_Result)) ) break;
			else
			{
				PLC_ExecStatement(Statement,NULL);
				if(PLC_FlowStatus==PLC_FLOW_BREAK) {PLC_FlowStatus=PLC_FLOW_NORMAL; break;}
				else if(PLC_FlowStatus==PLC_FLOW_RETURN || PLC_FlowStatus==PLC_FLOW_GOTO) break;
				else if(PLC_FlowStatus==PLC_FLOW_CONTINUE) PLC_FlowStatus=PLC_FLOW_NORMAL;
			}
		}
		break;

	// FOR
	case TT_KEY_FOR:
		Expression1=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		Expression2=PLC_TOKENNEXT(&Expression1->Link);
		Expression3=PLC_TOKENNEXT(&Expression2->Link);
		Statement=PLC_TOKENNEXT(&Expression3->Link);
		PLC_ExecExpression(PLC_TOK_Anchor(Expression1));
		while(1)
		{
			if(Expression2!=NULL)
			{
				PLC_ExecExpression(PLC_TOK_Anchor(Expression2));
				if(!PLC_DT_GetBool(&PLC_Result)) break;
			}
			PLC_ExecStatement(Statement,NULL);
			if(PLC_FlowStatus==PLC_FLOW_BREAK) {PLC_FlowStatus=PLC_FLOW_NORMAL; break;}
			else if(PLC_FlowStatus==PLC_FLOW_RETURN || PLC_FlowStatus==PLC_FLOW_GOTO) break;
			else if(PLC_FlowStatus==PLC_FLOW_CONTINUE) PLC_FlowStatus=PLC_FLOW_NORMAL;
			PLC_ExecExpression(PLC_TOK_Anchor(Expression3));
		}
		break;

	// SWITCH
	case TT_KEY_SWITCH:
		Expression1=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		Statement=PLC_TOKENNEXT(&Expression1->Link);
		PLC_ExecExpression(PLC_TOK_Anchor(Expression1));
		// PLC_Result contains value - SEARCH FOR CASE that matches value
		{
			PLC_TOKEN *StatementDefault = NULL;
			if(Statement->Type==PLC_TT_COMPOUND) Statement=PLC_TOKENNEXT(PLC_TOK_Anchor(Statement));
			while(Statement!=NULL)
			{
				if(Statement->Type==PLC_TT_KEYWORD && (Statement->SubType==TT_KEY_CASE || Statement->SubType==TT_KEY_DEFAULT))
				{
					if(Statement->SubType==TT_KEY_DEFAULT) StatementDefault = Statement;
					else
					{
						// first token of "case" keyword is datatype
						PLC_DATATYPE	*DataType=(PLC_DATATYPE*)PLC_TOK_Pointer( PLC_TOKENNEXT(PLC_TOK_Anchor(Statement)) );
						if(PLC_DT_Compare(&PLC_Result,DataType)==0) break;
					}
				}
				Statement=PLC_TOKENNEXT(&Statement->Link);
			}
			// EXECUTE CURRENT CASE
			if(Statement==NULL) Statement = StatementDefault;
			if(Statement!=NULL)
			{
				PLC_ExecCompound(PLC_TOKENNEXT(&Statement->Link));
				if(PLC_FlowStatus==PLC_FLOW_BREAK) PLC_FlowStatus=PLC_FLOW_NORMAL;
			}
		}
		break;

	// IGNORE
	case TT_KEY_CASE:
	case TT_KEY_DEFAULT:
		break;

	// PROGRAM FLOW KEYWORDS
	case TT_KEY_CONTINUE:
		PLC_FlowStatus=PLC_FLOW_CONTINUE;
		break;

	case TT_KEY_BREAK:
		PLC_FlowStatus=PLC_FLOW_BREAK;
		break;

	case TT_KEY_RETURN:
		Expression1=PLC_TOKENNEXT(PLC_TOK_Anchor(Token));
		PLC_ExecExpression(PLC_TOK_Anchor(Expression1));
		PLC_FlowStatus=PLC_FLOW_RETURN;
		break;

/*
	case TT_KEY_GOTO:
		PLC_SYMBOL	*Symbol=(PLC_SYMBOL*)PLC_TOK_Pointer(Token);
		Symbol=PLC_SymbolSearch(Symbol->Name,0,false);		// atp-search local scope only!
		if(Symbol==NULL || Symbol->LabelTarget==NULL) PLC_Err(PLC_ERR_UNKNOWN_LABEL_s,((PLC_SYMBOL*)PLC_TOK_Pointer(Token))->Name);
		PLC_GotoToken=Symbol->LabelTarget;
		PLC_FlowStatus=PLC_FLOW_GOTO;
		break;
*/
	}
}

//******************************************************************************

// apply an operator to its affected expressions
// if a variable is being used for the first time, it must be initialized and
// the data type auto-detected
void	ApplyOperator(sdword OperNum,PLC_DATATYPE *Val1,PLC_DATATYPE *Val2)
{
	char	TempStr[PLC_DT_STRING_MAX+1];
	bool	OperFound=true;

	if(PLC_Result.Type!=PLC_DT_NONE) PLC_DT_Destroy(&PLC_Result);
	if(Val1->Type==PLC_DT_NONE)
	{
		if(OperNum>=TT_OPR_ASSIGN && OperNum<=TT_OPR_ASSIGN_SHR) PLC_DT_Init(Val1 , Val2->Type);
		else if(OperNum>=TT_OPR_INCREMENT_PRE && OperNum<=TT_OPR_DECREMENT_POST) PLC_DT_Init(Val1 , PLC_DT_INT);
		else PLC_Err(PLC_ERR_VARIABLE_REFERENCED_s,Val1->Symbol==NULL? "Unknown" : Val1->Symbol->Name);
	}
	switch(OperNum)
	{
	case TT_OPR_COMMA:			break;
	// assignment
	case TT_OPR_ASSIGN:
		PLC_DT_Assign(&PLC_Result , Val2);
		break;
	case TT_OPR_INCREMENT_POST:
		if(Val1->Type==PLC_DT_NONE) PLC_DT_Init(Val1,PLC_DT_INT);
		PLC_DT_Assign(&PLC_Result , Val1);
	case TT_OPR_INCREMENT_PRE:
		if(Val1->Type==PLC_DT_NONE) PLC_DT_Init(Val1,PLC_DT_INT);
		if(Val1->Type==PLC_DT_INT) PLC_DT_SetInt(Val1 , PLC_DT_GetInt(Val1) + 1);
		else if(Val1->Type==PLC_DT_FLOAT) PLC_DT_SetFloat(Val1 , PLC_DT_GetFloat(Val1) + 1);
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		if(PLC_Result.Type==PLC_DT_NONE) PLC_DT_Assign(&PLC_Result , Val1);
		break;
	case TT_OPR_DECREMENT_POST:
		if(Val1->Type==PLC_DT_NONE) PLC_DT_Init(Val1,PLC_DT_INT);
		PLC_DT_Assign(&PLC_Result , Val1);
	case TT_OPR_DECREMENT_PRE:
		if(Val1->Type==PLC_DT_NONE) PLC_DT_Init(Val1,PLC_DT_INT);
		if(Val1->Type==PLC_DT_INT) PLC_DT_SetInt(Val1 , PLC_DT_GetInt(Val1) - 1);
		else if(Val1->Type==PLC_DT_FLOAT) PLC_DT_SetFloat(Val1 , PLC_DT_GetFloat(Val1) - 1);
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		if(PLC_Result.Type==PLC_DT_NONE) PLC_DT_Assign(&PLC_Result , Val1);
		break;

	// one operand
	case TT_OPR_NEGATE:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , !PLC_DT_GetInt(Val1));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetInt(&PLC_Result , !PLC_DT_GetFloat(Val1));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_COMPLEMENT:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , ~PLC_DT_GetInt(Val1));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_UNARY_PLUS:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , +PLC_DT_GetInt(Val1));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetFloat(&PLC_Result , +PLC_DT_GetFloat(Val1));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_UNARY_MINUS:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , -PLC_DT_GetInt(Val1));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetFloat(&PLC_Result , -PLC_DT_GetFloat(Val1));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;

	// two operands
	case TT_OPR_ASSIGN_MULT:
	case TT_OPR_MULTIPLY:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) * PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetFloat(&PLC_Result, PLC_DT_GetFloat(Val1) * PLC_DT_GetFloat(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_DIV:
	case TT_OPR_DIVIDE:
	case TT_OPR_ASSIGN_MOD:
	case TT_OPR_MODULUS:
		if(Val2->Type==PLC_DT_INT)
		{
			if(PLC_DT_GetInt(Val2)==0) PLC_Err(PLC_ERR_DIV_ZERO);
		}
		else if(Val2->Type==PLC_DT_FLOAT)
		{			
			if(PLC_DT_GetFloat(Val2)==0) PLC_Err(PLC_ERR_DIV_ZERO);
		}
		switch(OperNum)
		{
		case TT_OPR_ASSIGN_DIV:
		case TT_OPR_DIVIDE:
			if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) / PLC_DT_GetInt(Val2));
			else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetFloat(&PLC_Result, PLC_DT_GetFloat(Val1) / PLC_DT_GetFloat(Val2));
			else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
			break;
		case TT_OPR_ASSIGN_MOD:
		case TT_OPR_MODULUS:
			if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) % PLC_DT_GetInt(Val2));
			else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
			break;
		}
		break;
	case TT_OPR_ASSIGN_ADD:
	case TT_OPR_ADD:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) + PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetFloat(&PLC_Result, PLC_DT_GetFloat(Val1) + PLC_DT_GetFloat(Val2));
		else if(Val1->Type==PLC_DT_STRING)
		{
			if(strlen(PLC_DT_GetString(Val1))+strlen(PLC_DT_GetString(Val2)) >= PLC_DT_STRING_MAX) PLC_Err(PLC_ERR_ERROR_s,"String too long");
			strcpy(TempStr,PLC_DT_GetString(Val1));
			strcat(TempStr,PLC_DT_GetString(Val2));
			PLC_DT_SetString(&PLC_Result,TempStr);
		}
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_SUB:
	case TT_OPR_SUBTRACT:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) - PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetFloat(&PLC_Result, PLC_DT_GetFloat(Val1) - PLC_DT_GetFloat(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_SHL:
	case TT_OPR_SHL:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) << PLC_DT_GetInt(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_SHR:
	case TT_OPR_SHR:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) >> PLC_DT_GetInt(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_AND:
	case TT_OPR_AND:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) & PLC_DT_GetInt(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_XOR:
	case TT_OPR_XOR:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) ^ PLC_DT_GetInt(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_ASSIGN_OR:
	case TT_OPR_OR:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetInt(&PLC_Result , PLC_DT_GetInt(Val1) | PLC_DT_GetInt(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	
	// comparison
	case TT_OPR_LESS:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetBool(&PLC_Result , PLC_DT_GetInt(Val1) < PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetBool(&PLC_Result , PLC_DT_GetFloat(Val1) < PLC_DT_GetFloat(Val2));
		else if(Val1->Type==PLC_DT_STRING)	PLC_DT_SetBool(&PLC_Result , strcmp(PLC_DT_GetString(Val1),PLC_DT_GetString(Val2)) < 0);
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_LESS_EQUAL:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetBool(&PLC_Result , PLC_DT_GetInt(Val1) <= PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetBool(&PLC_Result , PLC_DT_GetFloat(Val1) <= PLC_DT_GetFloat(Val2));
		else if(Val1->Type==PLC_DT_STRING)	PLC_DT_SetBool(&PLC_Result , strcmp(PLC_DT_GetString(Val1),PLC_DT_GetString(Val2)) <= 0);
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_GREATER:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetBool(&PLC_Result , PLC_DT_GetInt(Val1) > PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetBool(&PLC_Result , PLC_DT_GetFloat(Val1) > PLC_DT_GetFloat(Val2));
		else if(Val1->Type==PLC_DT_STRING)	PLC_DT_SetBool(&PLC_Result , strcmp(PLC_DT_GetString(Val1),PLC_DT_GetString(Val2)) > 0);
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_GREATER_EQUAL:
		if(Val1->Type==PLC_DT_INT)			PLC_DT_SetBool(&PLC_Result , PLC_DT_GetInt(Val1) >= PLC_DT_GetInt(Val2));
		else if(Val1->Type==PLC_DT_FLOAT)	PLC_DT_SetBool(&PLC_Result , PLC_DT_GetFloat(Val1) >= PLC_DT_GetFloat(Val2));
		else if(Val1->Type==PLC_DT_STRING)	PLC_DT_SetBool(&PLC_Result , strcmp(PLC_DT_GetString(Val1),PLC_DT_GetString(Val2)) >= 0);
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_EQUAL:
		PLC_DT_SetBool(&PLC_Result , PLC_DT_Compare(Val1,Val2)==0);
		break;
	case TT_OPR_NOT_EQUAL:
		PLC_DT_SetBool(&PLC_Result , PLC_DT_Compare(Val1,Val2)!=0);
		break;
	case TT_OPR_LOGICAL_AND:
		if(Val1->Type==PLC_DT_INT || Val1->Type==PLC_DT_FLOAT) PLC_DT_SetBool(&PLC_Result , PLC_DT_GetBool(Val1) && PLC_DT_GetBool(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	case TT_OPR_LOGICAL_OR:
		if(Val1->Type==PLC_DT_INT || Val1->Type==PLC_DT_FLOAT) PLC_DT_SetBool(&PLC_Result , PLC_DT_GetBool(Val1) || PLC_DT_GetBool(Val2));
		else PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
		break;
	default:
		OperFound=false;
		break;
	}
	if(OperNum>=TT_OPR_ASSIGN && OperNum<=TT_OPR_ASSIGN_SHR)
	{
		OperFound=true;
		PLC_DT_Assign(Val1,&PLC_Result);
	}
	if(!OperFound) PLC_Err(PLC_ERR_ILLEGAL_OPERATION);
}

//******************************************************************************
//******************************************************************************
// PUBLIC ROUTINES

void	PLC_C_Init			(void)
{
	// compilation
	PLC_KeywordMax=sizeof(KeywordList)/sizeof(PLC_KEYWORD);
	PLC_OperatorMax=sizeof(OperatorList)/sizeof(PLC_OPERATOR);
	PLC_Common=Common;
	PLC_Keywords=KeywordList;
	PLC_Operators=OperatorList;
	// execution
	PLC_ExecKeyword=ExecKeyword;
	PLC_ApplyOperator=ApplyOperator;
}

//******************************************************************************
//******************************************************************************
