//******************************************************************************
// ADEPT SOFTWARE STANDARD LIBRARY              Copyright 1999 Adept Software **
//******************************************************************************

#ifndef ADEPT_H
#define ADEPT_H

#define WIN32_LEAN_AND_MEAN
#include <wtypes.h>
#include <crtdbg.h>
#include <stdio.h>
#include <stdlib.h>

//******************************************************************************
//******************************************************************************
// DATA TYPES

typedef unsigned char	byte;
typedef signed char		sbyte;
typedef unsigned short	word;
typedef signed short	sword;
typedef unsigned long	dword;
typedef signed long		sdword;

struct LNK_LINK
{
	LNK_LINK	*Prev,*Next;
	bool		Anchor;
};

//******************************************************************************
//******************************************************************************
// MACROS

#define samesign(Value1,Value2)	((Value1>=0 && Value2>=0) || (Value1<=0 && Value2<=0))
#define toggle(Var)				(Var=!(Var))
#define incmax(Var,Max)			(Var=(++(Var)>=(Max))? (Max) : (Var))
#define incwrap(Var,Max)		(Var=(++(Var)>=(Max))? 0 : (Var))
#define bitson(Var,Bits)		(Var=(Var) | (Bits))
#define bitsoff(Var,Bits)		(Var^=(Var) & (Bits))
#define bitsset(Var,Bits,Flag)	(Var=((Var)&~(Bits)) | ((Flag)? Bits : 0))
#define bitstoggle(Var,Bits)	(Var^=(Bits))

#define clip(Value,Low,High)	( (Value<Low)? Low : ((Value>High)? High : Value) )

#define makeword(Byte1,Byte2)	((word)(Byte1)|((word)(Byte2)<<8))
#define makedword(Byte1,Byte2,Byte3,Byte4)	((sdword)(Byte1)|((sdword)(Byte2)<<8)|((sdword)(Byte3)<<16)|((sdword)(Byte4)<<24))

#define invertword(Word)	(((word)_byte0(Word)<<8)|((word)_byte1(Word)))
#define invertdword(DWord)	(((dword)_byte0(DWord)<<24)|((dword)_byte1(DWord)<<16)|((dword)_byte2(DWord)<<8)|((dword)_byte3(DWord)))

#define _voidptr(Pointer)	(((void**)&(Pointer))[0])
#define _byte0(Number)		(((byte*)&(Number))[0])
#define _byte1(Number)		(((byte*)&(Number))[1])
#define _byte2(Number)		(((byte*)&(Number))[2])
#define _byte3(Number)		(((byte*)&(Number))[3])
#define _word0(Number)		(((word*)&(Number))[0])
#define _word1(Number)		(((word*)&(Number))[1])
#define _dword0(Number)		(((dword*)&(Number))[0])

#define ptrclone(Dest,Ptr)			((void**)&(Dest))[0] = (void*) (Ptr)
#define ptrset(Dest,Ptr,Adder)		((void**)&(Dest))[0] = (void*) ( ((dword)(Ptr))+(Adder) )
#define ptradd(Ptr,Adder)			(void*) ( ((dword)(Ptr)) + (Adder) )
#define ptrinc(Dest)				((dword*)&(Dest))[0]++
#define ptrdec(Dest)				((dword*)&(Dest))[0]--

#define strcpymax(Dest,Src,Max)		(strncpy((Dest),(Src),(Max)),((byte*)(Dest))[(Max)-1]=0)

//******************************************************************************
//******************************************************************************
// ROUTINES

#define MEM_Alloc(BufPtr,Size)		MEM_Alloc1((void**)(BufPtr),(Size));
#define MEM_AllocInit(BufPtr,Size)	MEM_AllocInit1((void**)(BufPtr),(Size));
#define MEM_Realloc(BufPtr,Size)	MEM_Realloc1((void**)(BufPtr),(Size));
#define MEM_ReallocInit(BufPtr,OldSize,Size)	MEM_ReallocInit1((void**)(BufPtr),(OldSize),(Size));
#define MEM_Free(BufPtr)			MEM_Free1((void**)(BufPtr));

void	MEM_Alloc1			(void **BufferPtr,dword Size);
void	MEM_AllocInit1		(void **BufferPtr,dword Size);
void	MEM_Realloc1		(void **BufferPtr,dword Size);
void	MEM_ReallocInit1	(void **BufferPtr,dword OldSize,dword Size);
void	MEM_Free1			(void **BufferPtr);

void	LNK_AnchorInit		(LNK_LINK *Anchor);
void	LNK_LinkInit		(LNK_LINK *Link);
void	LNK_AddAfter		(LNK_LINK *OrigLink,LNK_LINK *Link);	// inits link automatically
void	LNK_AddBefore		(LNK_LINK *OrigLink,LNK_LINK *Link);	// inits link automatically
void	LNK_MoveAfter		(LNK_LINK *OrigLink,LNK_LINK *Link);
void	LNK_MoveBefore		(LNK_LINK *OrigLink,LNK_LINK *Link);
void	LNK_Remove			(LNK_LINK *Link);
void	LNK_Relocate		(LNK_LINK *Link,void *OldLinkPos);
void	*LNK_Next			(LNK_LINK *Link);
void	*LNK_Prev			(LNK_LINK *Link);

#endif
